;;*****************************************************************************
;;*****************************************************************************
;;  FILENAME: QP1A.inc
;;   Version: 2.3, Updated on 2004/07/29 at 17:41:18
;;  Generated by PSoC Designer ver 4.2  b1013 : 02 September, 2004
;;
;;  DESCRIPTION: Assembler declarations for the Counter8 user module interface
;;               for the 22/24/27/29xxx PSoC family of devices
;;-----------------------------------------------------------------------------
;;  Copyright (c) Cypress MicroSystems 2000-2004. All Rights Reserved.
;;*****************************************************************************
;;*****************************************************************************

include "m8c.inc"


;--------------------------------------------------
; Constants for QP1A API's.
;--------------------------------------------------

QP1A_CONTROL_REG_START_BIT:                equ 0x01    ; Control register start bit
QP1A_INT_REG:                              equ 0x0df
QP1A_INT_MASK:                             equ 0x08


;--------------------------------------------------
; Constants for QP1A user defined values
;--------------------------------------------------

QP1A_PERIOD:                               equ 0xff
QP1A_COMPARE_VALUE:                        equ 0x00


;--------------------------------------------------
; Register Address Constants for QP1A
;--------------------------------------------------

QP1A_COUNTER_REG:                      equ 0x4c   ; DR0 Counter register
QP1A_PERIOD_REG:                       equ 0x4d   ; DR1 Period register
QP1A_COMPARE_REG:                      equ 0x4e   ; DR2 CompareValue register
QP1A_CONTROL_REG:                      equ 0x4f   ; Control register
QP1A_FUNC_REG:                         equ 0x4c   ; Function register
QP1A_INPUT_REG:                        equ 0x4d   ; Input register
QP1A_OUTPUT_REG:                       equ 0x4e   ; Output register


;--------------------------------------------------
; QP1A Macro 'Functions'
;--------------------------------------------------

   macro QP1A_Start_M
   or    reg[QP1A_CONTROL_REG],  QP1A_CONTROL_REG_START_BIT
   endm

   macro QP1A_Stop_M
   and   reg[QP1A_CONTROL_REG], ~QP1A_CONTROL_REG_START_BIT
   endm

   macro QP1A_EnableInt_M
   M8C_EnableIntMask QP1A_INT_REG, QP1A_INT_MASK
   endm

   macro QP1A_DisableInt_M
   M8C_DisableIntMask QP1A_INT_REG, QP1A_INT_MASK
   endm


; end of file QP1A.inc
